"""
https://tk-tools.readthedocs.io/en/latest/widget_groups.html
https://www.python-course.eu/tkinter_canvas.php
https://www.python-kurs.eu/tkinter_labels.php
https://stackoverflow.com/questions/2400262/how-to-create-a-timer-using-tkinter
https://raspberrypi.stackexchange.com/questions/91517/tkinter-push-button-with-virtual-buttons

Python installieren
https://www.computerwoche.de/a/wie-sie-python-richtig-installieren,3548847

PIP installieren
https://www.ephesossoftware.com/articles/programming/how-to-install-pip-for-python-on-windows-mac-and-linux.html

https://riptutorial.com/tkinter


Function name 	        Function code 	ModbusClient function
Bit
Read Discrete Inputs 	2 	        read_discrete_inputs()
Read Coils 	        1 	        read_coils()
Write Single Coil 	5 	        write_single_coil()
Write Multiple Coils 	15 	        write_multiple_coils()

Register
Read Input Registers 	4 	        read_input_registers()
Read Holding Registers 	3 	        read_holding_registers()
Write Single Register 	6 	        write_single_register()
Write Multiple Registers 16 	        write_multiple_registers()


"""
from tkinter import *
from pyModbusTCP.client import ModbusClient
import time

# ESP8266 IP Adress
SERVER_HOST = "192.168.178.101"
# Modbus TCP Port
SERVER_PORT = 502
# Modbus Server ID
SERVER_U_ID = 1

c = ModbusClient()

# define modbus server host, port and unit_id
c.host(SERVER_HOST)
c.port(SERVER_PORT)
c.unit_id(SERVER_U_ID)

if not c.is_open():
    if not c.open():
        print("unable to connect to "+SERVER_HOST+":"+str(SERVER_PORT))

# Variable
state_timer = 0

state_qx0_0 = 0
state_qx0_1 = 0
state_qx0_2 = 0
state_qx0_3 = 0

state_ix0_0 = 0
state_ix0_1 = 0
state_ix0_2 = 0
state_ix0_3 = 0

adc_value = 0

slider_value = 0;

enable = 1

counter = 0

_callback_id = None

# Functions
def close_window():
    mainwindow.destroy()

def button_action_q0():
    global state_qx0_0
    #global _callback_id
    if (state_qx0_0 == 0):
        state_qx0_0 = 1
        #state_q0_0_label.config(text="ON")
        change_button_qx0_0.config(text="QX0_0 OFF")
        c.write_single_coil(0, 1)
    else:
        state_qx0_0 = 0
        #state_q0_0_label.config(text="OFF")
        change_button_qx0_0.config(text="QX0_0 ON ")
        c.write_single_coil(0, 0)

def button_action_q1():
    global state_qx0_1
    if (state_qx0_1 == 0):
        state_qx0_1 = 1
        #state_q0_1_label.config(text="ON")
        change_button_qx0_1.config(text="QX0_1 OFF")
        c.write_single_coil(1, 1)        
    else:
        state_qx0_1 = 0
        #state_q0_1_label.config(text="OFF")
        change_button_qx0_1.config(text="QX0_1 ON ")
        #enable = 0
        c.write_single_coil(1, 0)
        
def button_action_q2():
    global state_qx0_2
    if (state_qx0_2 == 0):
        state_qx0_2 = 1
        #state_q0_2_label.config(text="ON")
        change_button_qx0_2.config(text="QX0_2 OFF")
        c.write_single_coil(2, 1)     
    else:
        state_qx0_2 = 0
        #state_q0_2_label.config(text="OFF")
        change_button_qx0_2.config(text="QX0_2 ON ")
        c.write_single_coil(2, 0)        

def button_action_q3():
    global state_qx0_3
    if (state_qx0_3 == 0):
        state_qx0_3 = 1
        #state_q0_3_label.config(text="ON")
        change_button_qx0_3.config(text="QX0_3 OFF")
        c.write_single_coil(3, 1)        
    else:
        state_qx0_3 = 0
        #state_q0_3_label.config(text="OFF")
        change_button_qx0_3.config(text="QX0_3 ON ")
        c.write_single_coil(3, 0)        

def button_start_stop():
    global enable
    global state_timer
    if (state_timer == 0):
        state_timer = 1
        stop_clock()
        start_stop_button.config(text="Start")
    else:
        state_timer = 0
        enable = 1
        start_clock()
        start_stop_button.config(text="Stop")

# Slider changed
def slider_action(val):
    u = slider.get()
    info_label.config(text=u)
    #now = time.strftime("%H:%M:%S")
    #time_label.config(text=now)

    # Write DAC
    c.write_single_register(0,u)
    
# Timer Start
def start_clock():
    global _callback_id
    global counter
    #now = time.strftime("%H:%M:%S")
    counter = counter + 1
    #time_label.configure(text=now)
    time_label.configure(text=counter)
    if enable==1:
         _callback_id = mainwindow.after(100, start_clock)
    else:
         mainwindow.after_cancel(_callback_id)

    if c.is_open():
        # read 4 bits at address 0, store result in regs list
        bits = c.read_coils(0, 4)
        if bits[0] == 1:
            state_q0_0_label.config(text="ON")
        else:
            state_q0_0_label.config(text="OFF")

        if bits[1] == 1:
            state_q0_1_label.config(text="ON")
        else:
            state_q0_1_label.config(text="OFF")

        if bits[2] == 1:
            state_q0_2_label.config(text="ON")
        else:
            state_q0_2_label.config(text="OFF")

        if bits[3] == 1:
            state_q0_3_label.config(text="ON")
        else:
            state_q0_3_label.config(text="OFF")

        
        # if success display registers
        # if bits:
            #print("Coils at #0 to 3: "+str(bits))
        bits = c.read_discrete_inputs(0, 4)
        # print("Inputs at #0 to 3: "+str(bits))
        # if success display registers
        if bits[0] == 1:
            label_input_ix00.config(bg='red')            
        else:
            label_input_ix00.config(bg='green')
        if bits[1] == 1:
            label_input_ix01.config(bg='red')            
        else:
            label_input_ix01.config(bg='green')
        if bits[2] == 1:
            label_input_ix02.config(bg='red')            
        else:
            label_input_ix02.config(bg='green')
        if bits[3] == 1:
            label_input_ix03.config(bg='red')            
        else:
            label_input_ix03.config(bg='green')

        value = c.read_input_registers(0)
        a = float(value[0])
        b = 10 / 1023
        x = a*b
        a = "ADC: " + str(eval(format(float(x), '.1f')))
        label_input_adc.configure(text=a)

#Timer Stop
def stop_clock():
    global enable
    enable = 0
    

# create mainwindow
mainwindow = Tk()
# mainwindow title
mainwindow.title("Modbus TCP ESP8266 WIFI TestSoftware 1.0")

# size of mainwindow
mainwindow.geometry("480x320")
mainwindow.resizable(0, 0)


# Labels and Buttons
change_button_qx0_0 = Button(mainwindow, text="QX0_0 ON", command=button_action_q0)
change_button_qx0_1 = Button(mainwindow, text="QX0_1 ON", command=button_action_q1)
change_button_qx0_2 = Button(mainwindow, text="QX0_2 ON", command=button_action_q2)
change_button_qx0_3 = Button(mainwindow, text="QX0_3 ON", command=button_action_q3)

start_stop_button = Button(mainwindow, text="Stop", command=button_start_stop)

state_q0_0_label = Label(mainwindow, text="OFF")
state_q0_0_label.config(font=("Arial", 16))
state_q0_1_label = Label(mainwindow, text="OFF")
state_q0_1_label.config(font=("Arial", 16))
state_q0_2_label = Label(mainwindow, text="OFF")
state_q0_2_label.config(font=("Arial", 16))
state_q0_3_label = Label(mainwindow, text="OFF")
state_q0_3_label.config(font=("Arial", 16))

label_info_ix00 = Label(mainwindow, text="IX0.0")
label_input_ix00 = Label(mainwindow, text="      ", bg='green')

label_info_ix01 = Label(mainwindow, text="IX0.1")
label_input_ix01 = Label(mainwindow, text="      ", bg='green')

label_info_ix02 = Label(mainwindow, text="IX0.2")
label_input_ix02 = Label(mainwindow, text="      ", bg='green')

label_info_ix03 = Label(mainwindow, text="IX0.3")
label_input_ix03 = Label(mainwindow, text="      ", bg='green')


label_input_adc = Label(mainwindow, text="ADC..")
label_input_adc.config(font=("Arial", 16))

exit_button = Button(mainwindow, text="Beenden", command=close_window)

slider = Scale(from_=0, to=1023, resolution=1, orient=HORIZONTAL, command=slider_action )

info_label = Label(mainwindow, text="DAC Value..")

time_label = Label(mainwindow)


state_q0_0_label.place(x = 20, y = 40, width=80, height=30)
change_button_qx0_0.place(x = 100, y = 40, width=80, height=30)

state_q0_1_label.place(x = 20, y = 80, width=80, height=30)
change_button_qx0_1.place(x = 100, y = 80, width=80, height=30)

state_q0_2_label.place(x = 20, y = 120, width=80, height=30)
change_button_qx0_2.place(x = 100, y = 120, width=80, height=30)

state_q0_3_label.place(x = 20, y = 160, width=80, height=30)
change_button_qx0_3.place(x = 100, y = 160, width=80, height=30)

exit_button.place(x = 340, y = 280, width=80, height=30)
start_stop_button.place(x = 20, y = 280, width=60, height=30)


label_info_ix00.place(x = 260, y = 40, width=80, height=30)
label_input_ix00.place(x = 340, y = 40, width=80, height=30)

label_info_ix01.place(x = 260, y = 80, width=80, height=30)
label_input_ix01.place(x = 340, y = 80, width=80, height=30)

label_info_ix02.place(x = 260, y = 120, width=80, height=30)
label_input_ix02.place(x = 340, y = 120, width=80, height=30)

label_info_ix03.place(x = 260, y = 160, width=80, height=30)
label_input_ix03.place(x = 340, y = 160, width=80, height=30)


info_label.place(x = 200, y = 240, width=80, height=30)

label_input_adc.place(x = 200, y = 280, width=120, height=30)

time_label.place(x = 80, y = 280, width=80, height=30)

slider.place(x = 30, y = 190, width=420, height=40)

# Outputs to 0
c.write_single_coil(0,0)
c.write_single_coil(1,0)
c.write_single_coil(2,0)
c.write_single_coil(3,0)

# Timer start
start_clock()

# Mainloop
mainwindow.mainloop()
